# -*- coding: utf-8 -*-
#
# OpenMW documentation build configuration file, created by
# sphinx-quickstart on Wed May 14 15:16:35 2014.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.
import re
import os
import sys
import subprocess

from dataclasses import asdict
from sphinxawesome_theme import ThemeOptions
from sphinxawesome_theme.postprocess import Icons

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
project_root = os.path.abspath('../../')
sys.path.insert(0, project_root)
sys.path.append(os.path.abspath("_ext"))

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
needs_sphinx = '1.8'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.todo',
    'sphinx.ext.coverage',
    'sphinx.ext.viewcode',
    'sphinx.ext.autosectionlabel',
    'sphinx_design',
    'omw-directives',
    'omw-lexers',
]

#autosectionlabel_prefix_document = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = '.rst'

# The encoding of source files.
#source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = 'index'

# General information about the project.
project = u'OpenMW'
copyright = u'2024, OpenMW Team'


# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
# The full version, including alpha/beta/rc tags.

release = version = "UNRELEASED"
luaApiRevision = "UNKNOWN"
ppApiRevision = "UNDEFINED"

try:
    cmake_raw = open(project_root+'/CMakeLists.txt', 'r').read()
    majorVersionMatch = re.search(r'set\(OPENMW_VERSION_MAJOR (\d+)\)', cmake_raw)
    minorVersionMatch = re.search(r'set\(OPENMW_VERSION_MINOR (\d+)\)', cmake_raw)
    releaseVersionMatch = re.search(r'set\(OPENMW_VERSION_RELEASE (\d+)\)', cmake_raw)
    if majorVersionMatch and minorVersionMatch and releaseVersionMatch:
        release = version = '.'.join((majorVersionMatch.group(1),
                                     minorVersionMatch.group(1),
                                     releaseVersionMatch.group(1)))
    luaApiRevisionMatch = re.search(r'set\(OPENMW_LUA_API_REVISION (\d+)\)', cmake_raw)
    if luaApiRevisionMatch:
        luaApiRevision = luaApiRevisionMatch.group(1)
    ppApiRevisionMatch = re.search(r'set\(OPENMW_POSTPROCESSING_API_REVISION (\d+)\)', cmake_raw)
    if ppApiRevisionMatch:
        ppApiRevision = ppApiRevisionMatch.group(1)

except Exception as ex:
    print("WARNING: Version will be set to '{0}' because: '{1}'.".format(release, str(ex)))
    import traceback; traceback.print_exc()

rst_prolog = f"""
.. |luaApiRevision| replace:: {luaApiRevision}
.. |luaApiRevisionBadge| replace:: :bdg-link-info-line:`API v{luaApiRevision} <openmw_core.html##(core).API_REVISION>`

.. |ppApiRevision| replace:: {ppApiRevision}
.. |bdg-ctx-menu| replace:: :bdg-warning:`menu`
.. |bdg-ctx-global| replace:: :bdg-danger:`global`
.. |bdg-ctx-player| replace:: :bdg-secondary:`player`
.. |bdg-ctx-local| replace:: :bdg-info:`local`
.. |bdg-ctx-all| replace:: :bdg-danger:`global` :bdg-warning:`menu` :bdg-info:`local`
"""

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#language = cpp

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
#today = ''
# Else, today_fmt is used as the format for a strftime call.
#today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = []

# The reST default role (used for this markup: `text`) to use for all
# documents.
#default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
#add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
#add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
#show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'default'
pygments_style_dark = 'github-dark'

# A list of ignored prefixes for module index sorting.
#modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
#keep_warnings = False

primary_domain = 'c'

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = 'sphinxawesome_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = asdict(ThemeOptions(
   show_breadcrumbs=False,
   main_nav_links= {
        "Modding": "reference/modding/index",
        "Lua API": "reference/lua-scripting/overview",
        "Post-Processing": "reference/postprocessing/index",
   },
   show_scrolltop=False, # Useful, but hard to position with the Flyout addon since the best place for that is bottom right
))

html_permalinks_icon = Icons.permalinks_icon

html_js_files = [
    'prism.js'
]

html_css_files = [
    "theme-override.css",
    "luadoc.css",
    "figures.css",
    "prism.css",
    "prism-dark.css",
]

# Add any paths that contain custom themes here, relative to this directory.
#html_theme_path = []

def setup(app):
    try:
        subprocess.call(['bash', project_root + '/docs/source/generate_luadoc.sh'])
    except Exception as e:
        print('Can\'t generate Lua API documentation:', e)

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = 'OpenMW'

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = 'OpenMW Documentation'

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = 'https://gitlab.com/OpenMW/openmw-docs/raw/master/docs/source/_static/images/openmw.png'

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
html_favicon = 'https://gitlab.com/OpenMW/openmw-docs/raw/master/docs/source/_static/images/favicon.png'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = [
    '_static'
]

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
#html_extra_path = []

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
#html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
#html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
#html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
#html_additional_pages = {}

# If false, no module index is generated.
#html_domain_indices = True

# If false, no index is generated.
#html_use_index = True

# If true, the index is split into individual pages for each letter.
#html_split_index = False

# If true, links to the reST sources are added to the pages.
#html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
#html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
#html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
#html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
#html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = 'OpenMWdoc'


# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
# The paper size ('letterpaper' or 'a4paper').
#'papersize': 'letterpaper',

# The font size ('10pt', '11pt' or '12pt').
#'pointsize': '10pt',

# Additional stuff for the LaTeX preamble.
#'preamble': '',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
  ('index', 'OpenMW.tex', u'OpenMW Documentation',
   u'Bret Curtis', 'manual'),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
#latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
#latex_use_parts = False

# If true, show page references after internal links.
#latex_show_pagerefs = False

# If true, show URL addresses after external links.
#latex_show_urls = False

# Documents to append as an appendix to all manuals.
#latex_appendices = []

# If false, no module index is generated.
#latex_domain_indices = True


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
    ('index', 'openmw', u'OpenMW Documentation',
     [u'Bret Curtis'], 1)
]

# If true, show URL addresses after external links.
#man_show_urls = False


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
  ('index', 'OpenMW', u'OpenMW Documentation',
   u'Bret Curtis', 'OpenMW', 'One line description of project.',
   'Miscellaneous'),
]

# Documents to append as an appendix to all manuals.
#texinfo_appendices = []

# If false, no module index is generated.
#texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
#texinfo_show_urls = 'footnote'

# If true, do not generate a @detailmenu in the "Top" node's menu.
#texinfo_no_detailmenu = False
