macro (find_tgz_deps)

        if(MINGW)
                set(SHARED_LIBRARY_SUFFIX "dll")
                set(SYSTEM_SHARED_LIB_PATH "${CMAKE_INSTALL_PREFIX}/bin")
                set(USER_SHARED_LIB_PATH "${CMAKE_INSTALL_PREFIX}/bin")
                set(LOCAL_SHARED_LIB_PATH "${CMAKE_INSTALL_PREFIX}/bin")
                set(LOCAL_SHARED_LIB_MULTILIB_PATH "${CMAKE_INSTALL_PREFIX}/bin")
                set(INSTALL_PATH ".")

                set(QPA_PLUGINS_PATH "${CMAKE_INSTALL_PREFIX}/lib/qt/plugins")

                INSTALL(FILES "${SYSTEM_SHARED_LIB_PATH}/libgcc_s_sjlj-1.${SHARED_LIBRARY_SUFFIX}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
                INSTALL(FILES "${SYSTEM_SHARED_LIB_PATH}/libstdc++-6.${SHARED_LIBRARY_SUFFIX}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
                INSTALL(FILES "${SYSTEM_SHARED_LIB_PATH}/libwinpthread-1.${SHARED_LIBRARY_SUFFIX}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        else(MINGW)
                exec_program("uname" ARGS "-m" OUTPUT_VARIABLE ARCH)
                if("${ARCH}" MATCHES "i686")
                    set(MULTIARCH_PATH "")
                else()
                    set(MULTIARCH_PATH "64")
                endif()
                set(SHARED_LIBRARY_SUFFIX "so")
                #set(SYSTEM_SHARED_LIB_PATH "/lib${MULTIARCH_PATH}")
                set(SYSTEM_SHARED_LIB_PATH "/usr/lib/x86_64-linux-gnu/")
                #set(USER_SHARED_LIB_PATH "/usr/lib${MULTIARCH_PATH}")
                set(USER_SHARED_LIB_PATH "/usr/lib/x86_64-linux-gnu/")
                set(LOCAL_SHARED_LIB_PATH "/usr/local/lib")
                if("${ARCH}" MATCHES "i686")
                        set(LIBDIR "lib")
                else()
                        set(LIBDIR "lib64")
                endif()
                set(LOCAL_SHARED_LIB_MULTILIB_PATH "/usr/local/${LIBDIR}")
                set(INSTALL_PATH "./lib")

                #set(QPA_PLUGINS_PATH "/usr/local/plugins")
                set(QPA_PLUGINS_PATH "${SYSTEM_SHARED_LIB_PATH}/qt6/plugins")
                # FIXME seems to not be set by FindOSG anymore
                set(OSGPlugins_LIB_DIR "${LOCAL_SHARED_LIB_PATH}/osgPlugins-3.6.5/")
        endif(MINGW)

        #set(FREEIMAGE_LIBRARY "/usr/lib/libfreeimage.so.3")
        set(JPEG_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libjpeg.so.62")
        #Don't package pthread it's just too system dependant
        #set(PTHREAD_LIBRARY "/lib/libpthread.so.0")
        IF(NOT MINGW)
            set(UUID_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libuuid.${SHARED_LIBRARY_SUFFIX}.1")
        ENDIF(NOT MINGW)
        #set(FLAC_LIBRARY "/usr/lib/${MULTIARCH_PATH}/libFLAC.so.8")
        set(VORBISENC_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libvorbisenc.so")
        set(VORBIS_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libvorbis.so")
        set(OGG_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libogg.so")
        #set(ZZIP_LIBRARY "/usr/lib/libzzip.so")
        # required by multithreaded bullet
        set(GOMP_LIBRARY "${USER_SHARED_LIB_PATH}/libgomp.so.1")
        # For openscenegraph since it picks up system libpng15 through cairo and rsvg (should fix openscenegraph build)
        #set(PNG15_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libpng15.${SHARED_LIBRARY_SUFFIX}.15")
        set(PNG_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libpng16.${SHARED_LIBRARY_SUFFIX}.16")
        #TODO: Add OSG Dependencies Cairo + librsvg
        # Use older expat library from local libs so we depend on glibc 2.35 instead of glibc 2.36
        #set(EXPAT_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libexpat.${SHARED_LIBRARY_SUFFIX}.1")
        set(EXPAT_LIBRARY "${LOCAL_SHARED_LIB_PATH}/libexpat.${SHARED_LIBRARY_SUFFIX}.1")
        set(GRAPHITE_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libgraphite2.${SHARED_LIBRARY_SUFFIX}.3")
        set(HARFBUZZ_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libharfbuzz.${SHARED_LIBRARY_SUFFIX}.0")
        set(GLIB_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libglib-2.0.${SHARED_LIBRARY_SUFFIX}.0")
        set(GTHREAD_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libgthread-2.0.${SHARED_LIBRARY_SUFFIX}.0")
        set(PCRE2_8_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libpcre2-8.${SHARED_LIBRARY_SUFFIX}.0")
        set(PCRE2_16_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libpcre2-16.${SHARED_LIBRARY_SUFFIX}.0")
        # Collada for osg dae plugin
        #set(COLLADA_LIBRARY "${LOCAL_SHARED_LIB_PATH}/libcollada-dom2.5-dp.${SHARED_LIBRARY_SUFFIX}.0")
        INSTALL(FILES "${SYSTEM_SHARED_LIB_PATH}/libcollada-dom2.5-dp.${SHARED_LIBRARY_SUFFIX}.2.5.0" DESTINATION "${INSTALL_PATH}" RENAME "libcollada-dom2.5-dp.${SHARED_LIBRARY_SUFFIX}.0" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
       # collada dependencies
        INSTALL(FILES "${SYSTEM_SHARED_LIB_PATH}/libboost_filesystem.${SHARED_LIBRARY_SUFFIX}.1.83.0" DESTINATION "${INSTALL_PATH}" RENAME "libboost_filesystem.${SHARED_LIBRARY_SUFFIX}.1.83.0" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        INSTALL(FILES "${SYSTEM_SHARED_LIB_PATH}/liburiparser.${SHARED_LIBRARY_SUFFIX}.1.0.31" DESTINATION "${INSTALL_PATH}" RENAME "liburiparser.${SHARED_LIBRARY_SUFFIX}.1" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        INSTALL(FILES "${SYSTEM_SHARED_LIB_PATH}/libminizip.${SHARED_LIBRARY_SUFFIX}.1.0.0" DESTINATION "${INSTALL_PATH}" RENAME "libminizip.${SHARED_LIBRARY_SUFFIX}.1" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
       #set(PCRECPP_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libpcrecpp.${SHARED_LIBRARY_SUFFIX}.0")
       set(XML2_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libxml2.${SHARED_LIBRARY_SUFFIX}.2")
       set(LZMA_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/liblzma.${SHARED_LIBRARY_SUFFIX}.5")
       set(LZ4_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/liblz4.${SHARED_LIBRARY_SUFFIX}.1")

       set(LUAJIT_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libluajit-5.1.${SHARED_LIBRARY_SUFFIX}.2")
       set(SQLITE_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libsqlite3.${SHARED_LIBRARY_SUFFIX}.0")
       set(BROTLIDEC_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libbrotlidec.${SHARED_LIBRARY_SUFFIX}.1")
       set(BROTLICOMMON_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libbrotlicommon.${SHARED_LIBRARY_SUFFIX}.1")

       set(DOUBLECONVERSION_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libdouble-conversion.${SHARED_LIBRARY_SUFFIX}.3")
       set(MD4C_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libmd4c.${SHARED_LIBRARY_SUFFIX}.0")
       set(B2_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libb2.${SHARED_LIBRARY_SUFFIX}.1")
       set(MD_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libmd.${SHARED_LIBRARY_SUFFIX}.0")
       set(CAP_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libcap.${SHARED_LIBRARY_SUFFIX}.2")
       set(BSD_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libbsd.${SHARED_LIBRARY_SUFFIX}.0")
       set(ZSTD_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libzstd.${SHARED_LIBRARY_SUFFIX}.1")

       set(XXHASH_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libxxhash.${SHARED_LIBRARY_SUFFIX}.0")

       #set(SDL2_LIBRARY "${LOCAL_SHARED_LIB_MULTILIB_PATH}/libSDL2")
       set(SDL2_LIBRARY "${LOCAL_SHARED_LIB_PATH}/libSDL2")
       #set(SDL2_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libSDL2")

       # OpenMW-CS/QNetwork dependencies
       #set(PROXY_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libproxy.${SHARED_LIBRARY_SUFFIX}.1")
       #INSTALL(FILES "${SYSTEM_SHARED_LIB_PATH}/libproxy.${SHARED_LIBRARY_SUFFIX}.0.5.9" DESTINATION "${INSTALL_PATH}" RENAME "libproxy.${SHARED_LIBRARY_SUFFIX}.1" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
       #set(PROXY_BACKEND_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libproxy/libpxbackend-1.0.${SHARED_LIBRARY_SUFFIX}")
       INSTALL(FILES "${LOCAL_SHARED_LIB_PATH}/x86_64-linux-gnu/libproxy.${SHARED_LIBRARY_SUFFIX}.0.5.9" DESTINATION "${INSTALL_PATH}" RENAME "libproxy.${SHARED_LIBRARY_SUFFIX}.1" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
       set(PROXY_BACKEND_LIBRARY "${LOCAL_SHARED_LIB_PATH}/x86_64-linux-gnu/libproxy/libpxbackend-1.0.${SHARED_LIBRARY_SUFFIX}")
       # libproxy backend deps (not required by selfbuild version)
       set(GOBJECT_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libgobject-2.0.${SHARED_LIBRARY_SUFFIX}.0")
       set(GMODULE_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libgmodule-2.0.${SHARED_LIBRARY_SUFFIX}.0")
       set(GIO_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libgio-2.0.${SHARED_LIBRARY_SUFFIX}.0")
       #set(DUKTAPE_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libduktape.${SHARED_LIBRARY_SUFFIX}.207")
       # gobject deps
       set(FFI_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libffi.${SHARED_LIBRARY_SUFFIX}.8")

       set(SELINUX_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libselinux.${SHARED_LIBRARY_SUFFIX}.1")

        ### FIXME: just install these for now can be changed later ###
        if("${ARCH}" MATCHES "i686")
        #        INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/sse2/libspeex.so.1.5.0" DESTINATION "./lib" RENAME libspeex.so.1 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        else()
        #        INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libspeex.so.1.5.0" DESTINATION "./lib" RENAME libspeex.so.1 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        endif()

        IF(MINGW)
          INSTALL(FILES "${LOCAL_SHARED_LIB_PATH}/libmp3lame-0.${SHARED_LIBRARY_SUFFIX}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ELSE(MINGW)
          INSTALL(FILES "${SYSTEM_SHARED_LIB_PATH}/libmp3lame.${SHARED_LIBRARY_SUFFIX}.0.0.0" DESTINATION "${INSTALL_PATH}" RENAME libmp3lame.${SHARED_LIBRARY_SUFFIX}.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ENDIF(MINGW)

        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libtheoraenc.so.1.1.2" DESTINATION "./lib" RENAME libtheoraenc.so.1 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libtheoradec.so.1.1.4" DESTINATION "./lib" RENAME libtheoradec.so.1 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/local/lib/libx264.so.152" DESTINATION "./lib" RENAME "libx264.so.152" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #FILE(GLOB LIBVPX "${LOCAL_SHARED_LIB_PATH}/libvpx.${SHARED_LIBRARY_SUFFIX}.*.*.*")
        FILE(GLOB LIBVPX "${USER_SHARED_LIB_PATH}/libvpx.${SHARED_LIBRARY_SUFFIX}.*.*.*")
        INSTALL(FILES "${LIBVPX}" DESTINATION "${INSTALL_PATH}" RENAME libvpx.${SHARED_LIBRARY_SUFFIX}.9 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libopenjpeg-2.1.3.0.so" DESTINATION "./lib" RENAME libopenjpeg.so.2 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libschroedinger-1.0.so.0.11.0" DESTINATION "./lib" RENAME libschroedinger-1.0.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libgnutls.so.26.22.4" DESTINATION "./lib" RENAME libgnutls.so.26 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libtasn1.so.3.1.16" DESTINATION "./lib" RENAME libtasn1.so.3 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libgsm.so.1.0.12" DESTINATION "./lib" RENAME libgsm.so.1 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/lib/${MULTIARCH_PATH}/libpng12.so.0.49.0" DESTINATION "./lib" RENAME libpng12.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/lib/${MULTIARCH_PATH}/libz.so.1.2.7" DESTINATION "./lib" RENAME libz.so.1 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/libzzip-0.so.13.0.56" DESTINATION "./lib" RENAME libzzip-0.so.13 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")

        set(LIBDEBUGUTILS_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libDebugUtils.${SHARED_LIBRARY_SUFFIX}.1")
        set(LIBDETOUR_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libDetour.${SHARED_LIBRARY_SUFFIX}.1")
        set(LIBRECAST_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libRecast.${SHARED_LIBRARY_SUFFIX}.1")

        IF(MINGW)
          FILE(GLOB LIBBZ2 "${SYSTEM_SHARED_LIB_PATH}/libbz2*.${SHARED_LIBRARY_SUFFIX}")
          INSTALL(FILES "${LIBBZ2}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ELSE(MINGW)
          FILE(GLOB LIBBZ2 "${SYSTEM_SHARED_LIB_PATH}/libbz2.${SHARED_LIBRARY_SUFFIX}.*.*.*")
          INSTALL(FILES "${LIBBZ2}" DESTINATION "${INSTALL_PATH}" RENAME libbz2.${SHARED_LIBRARY_SUFFIX}.1.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ENDIF(MINGW)

        IF(MINGW)
          FILE(GLOB LIBFREETYPE "${USER_SHARED_LIB_PATH}/libfreetype*.${SHARED_LIBRARY_SUFFIX}")
          INSTALL(FILES "${LIBFREETYPE}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ELSE(MINGW)
          FILE(GLOB LIBFREETYPE "${USER_SHARED_LIB_PATH}/libfreetype.${SHARED_LIBRARY_SUFFIX}.*.*.*")
          INSTALL(FILES "${LIBFREETYPE}" DESTINATION "${INSTALL_PATH}" RENAME libfreetype.${SHARED_LIBRARY_SUFFIX}.6 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ENDIF(MINGW)

        IF(MINGW)
          FILE(GLOB LIBYAMLCPP "${USER_SHARED_LIB_PATH}/libyaml-cpp*.${SHARED_LIBRARY_SUFFIX}")
          INSTALL(FILES "${LIBYAMLCPP}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ELSE(MINGW)
          #FILE(GLOB LIBYAMLCPP "${LOCAL_SHARED_LIB_MULTILIB_PATH}/libyaml-cpp.${SHARED_LIBRARY_SUFFIX}.*.*.*")
          FILE(GLOB LIBYAMLCPP "${SYSTEM_SHARED_LIB_PATH}/libyaml-cpp.${SHARED_LIBRARY_SUFFIX}.*.*.*")
          INSTALL(FILES "${LIBYAMLCPP}" DESTINATION "${INSTALL_PATH}" RENAME libyaml-cpp.${SHARED_LIBRARY_SUFFIX}.0.8 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ENDIF(MINGW)

        #INSTALL(FILES "/lib/${MULTIARCH_PATH}/libgcrypt.so.11.7.0" DESTINATION "./lib" RENAME libgcrypt.so.11 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/lib/${MULTIARCH_PATH}/libgpg-error.so.0.8.0" DESTINATION "./lib" RENAME libgpg-error.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")

        #New ffmpeg dependencies
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libvo-amrwbenc.so.0.0.3" DESTINATION "./lib" RENAME libvo-amrwbenc.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libvo-aacenc.so.0.0.3" DESTINATION "./lib" RENAME libvo-aacenc.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libfdk-aac.so.0.0.2" DESTINATION "./lib" RENAME libfdk-aac.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libcrystalhd.so.3.6" DESTINATION "./lib" RENAME libcrystalhd.so.3 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/librtmp.so.0" DESTINATION "./lib" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libmng.so.1.1.0.10" DESTINATION "./lib" RENAME libmng.so.1 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/libIlmImf.so.6.0.0" DESTINATION "./lib" RENAME libIlmImf.so.6 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/libImath.so.6.0.0" DESTINATION "./lib" RENAME libImath.so.6 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/libHalf.so.6.0.0" DESTINATION "./lib" RENAME libHalf.so.6 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/libIex.so.6.0.0" DESTINATION "./lib" RENAME libIex.so.6 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/libIlmThread.so.6.0.0" DESTINATION "./lib" RENAME libIlmThread.so.6 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libraw.so.5.0.0" DESTINATION "./lib" RENAME libraw.so.5 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libva.so.1.3200.0" DESTINATION "./lib" RENAME libva.so.1 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libxvidcore.so.4.3" DESTINATION "./lib" RENAME libxvidcore.so.4 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        IF(MINGW)
          set(FFMPEG_DEPS "libopencore-amrn*" "libopencore-amrw*" "libopenjp2*" "libspeex-*" "libtheora-*" "libtheoraenc-*" "libtheoradec-*" "libgomp*" "libaom*" "libgmp-*" "libmodplug*" "libsrt*" "libssh" "libgnutls-*" "libdav1d*" "libxml2*" "libogg*" "libbluray*" "libvorbis-*" "libvorbisenc-*" "libwebp-*" "libwebpmux-*" "libopus*" "libx264*" "libx265*" "xvidcore*" "libsoxr" "OpenAL32" "libhogweed*" "libidn2*" "libnettle*" "libp11-kit*" "libtasn*" "libunistring*" "libffi*")
          FOREACH(FFMPEG_DEP ${FFMPEG_DEPS})
                  #message("${FFMPEG_DEP}")
                  FILE(GLOB FFMPEG_DEP_GLOBBED "${LOCAL_SHARED_LIB_PATH}/${FFMPEG_DEP}.${SHARED_LIBRARY_SUFFIX}")
                  #message("${FFMPEG_DEP_GLOBBED}")
                  INSTALL(FILES "${FFMPEG_DEP_GLOBBED}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
          ENDFOREACH()
                  set(FFMPEG_DEPS "libgsm.${SHARED_LIBRARY_SUFFIX}.*.*.*" "libvpx.${SHARED_LIBRARY_SUFFIX}.*.*.*")
          FOREACH(FFMPEG_DEP ${FFMPEG_DEPS})
                  #message("${FFMPEG_DEP}")
                  FILE(GLOB FFMPEG_DEP_GLOBBED "${LOCAL_SHARED_LIB_PATH}/${FFMPEG_DEP}")
                  #message("${FFMPEG_DEP_GLOBBED}")
                  INSTALL(FILES "${FFMPEG_DEP_GLOBBED}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
          ENDFOREACH()
        ELSE(MINGW)
          #FILE(GLOB LIBOPUS "${LOCAL_SHARED_LIB_PATH}/libopus.${SHARED_LIBRARY_SUFFIX}.*.*.*")
          FILE(GLOB LIBOPUS "${SYSTEM_SHARED_LIB_PATH}/libopus.${SHARED_LIBRARY_SUFFIX}.*.*.*")
          INSTALL(FILES "${LIBOPUS}" DESTINATION "${INSTALL_PATH}" RENAME libopus.${SHARED_LIBRARY_SUFFIX}.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ENDIF(MINGW)

        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libopencore-amrnb.so.0.0.3" DESTINATION "./lib" RENAME libopencore-amrnb.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libopencore-amrwb.so.0.0.3" DESTINATION "./lib" RENAME libopencore-amrwb.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libfaac.so.0.0.0" DESTINATION "./lib" RENAME libfaac.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libaacplus.so.2.0.2" DESTINATION "./lib" RENAME libaacplus.so.2 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libbluray.so.1.1.0" DESTINATION "./lib" RENAME libbluray.so.1 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libts-0.0.so.0.1.1" DESTINATION "./lib" RENAME libts-0.0.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/liborc-0.4.so.0.16.0" DESTINATION "./lib" RENAME liborc-0.4.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libp11-kit.so.0.0.0" DESTINATION "./lib" RENAME libp11-kit.so.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/libjasper.so.1.0.0" DESTINATION "./lib" RENAME libjasper.so.1 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")

        #IF(NOT MINGW)
        #  INSTALL(FILES "/usr/local/lib/libtxc_dxtn.${SHARED_LIBRARY_SUFFIX}" DESTINATION "./lib" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #ENDIF(NOT MINGW)

        #INSTALL(FILES "/usr/local/lib/libx265.so.151" DESTINATION "./lib" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        IF(MINGW)
                FILE(GLOB LIBFONTCONFIG "${USER_SHARED_LIB_PATH}/libfontconfig*.${SHARED_LIBRARY_SUFFIX}")
                INSTALL(FILES "${LIBFONTCONFIG}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ELSE(MINGW)
                FILE(GLOB LIBFONTCONFIG "${USER_SHARED_LIB_PATH}/libfontconfig.${SHARED_LIBRARY_SUFFIX}.*.*.*")
                INSTALL(FILES "${LIBFONTCONFIG}" DESTINATION "${INSTALL_PATH}" RENAME "libfontconfig.${SHARED_LIBRARY_SUFFIX}.1" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ENDIF(MINGW)

        IF(MINGW)
                FILE(GLOB LIBSSL "${USER_SHARED_LIB_PATH}/libssl*.${SHARED_LIBRARY_SUFFIX}")
                INSTALL(FILES "${LIBSSL}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ELSE(MINGW)
                #FILE(GLOB LIBSSL "${USER_SHARED_LIB_PATH}/libssl.${SHARED_LIBRARY_SUFFIX}.*.*.*")
                FILE(GLOB LIBSSL "${USER_SHARED_LIB_PATH}/libssl.${SHARED_LIBRARY_SUFFIX}.*")
                INSTALL(FILES "${LIBSSL}" DESTINATION "${INSTALL_PATH}" RENAME "libssl.${SHARED_LIBRARY_SUFFIX}.3" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ENDIF(MINGW)
        IF(MINGW)
                FILE(GLOB LIBCRYPTO "${USER_SHARED_LIB_PATH}/libcrypto*.${SHARED_LIBRARY_SUFFIX}")
                INSTALL(FILES "${LIBCRYPTO}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ELSE(MINGW)
                #FILE(GLOB LIBCRYPTO "${USER_SHARED_LIB_PATH}/libcrypto.${SHARED_LIBRARY_SUFFIX}.*.*.*")
                FILE(GLOB LIBCRYPTO "${USER_SHARED_LIB_PATH}/libcrypto.${SHARED_LIBRARY_SUFFIX}.*")
                INSTALL(FILES "${LIBCRYPTO}" DESTINATION "${INSTALL_PATH}" RENAME "libcrypto.${SHARED_LIBRARY_SUFFIX}.3" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ENDIF(MINGW)

        string(REGEX REPLACE "(/.*libMyGUIEngine).${SHARED_LIBRARY_SUFFIX}.*" "\\1" MyGUI_LIBRARY_REAL "${MyGUI_LIBRARIES}")

        IF(MINGW)
                string(REGEX REPLACE "(.*)\/lib\/(.*)" "\\1/bin/\\2" MyGUI_LIBRARY_REAL "${MyGUI_LIBRARY_REAL}")
        ENDIF(MINGW)

        message("MyGUI: ${MyGUI_LIBRARIES}")
        message("MyGUI LIB REAL: ${MyGUI_LIBRARY_REAL}")

        IF(MINGW)
                FILE(GLOB LIBMYGUI "${MyGUI_LIBRARY_REAL}*.${SHARED_LIBRARY_SUFFIX}")
                INSTALL(FILES "${LIBMYGUI}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ELSE(MINGW)
                FILE(GLOB LIBMYGUI "${MyGUI_LIBRARY_REAL}.${SHARED_LIBRARY_SUFFIX}.*.*.*")
                INSTALL(FILES "${LIBMYGUI}" DESTINATION "${INSTALL_PATH}" RENAME "libMyGUIEngine.${SHARED_LIBRARY_SUFFIX}.3.4.3" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ENDIF(MINGW)

        #string(REGEX REPLACE ".*;?(/.*libSDL2).so;?.*" "\\1" SDL2_LIBRARY_REAL "${SDL2_LIBRARY}")
        string(REGEX REPLACE "(/.*libSDL2).${SHARED_LIBRARY_SUFFIX}.*" "\\1" SDL2_LIBRARY_REAL "${SDL2_LIBRARY}")
        IF(MINGW)
                string(REGEX REPLACE "(.*)\/lib\/lib(.*)" "\\1/bin/\\2" SDL2_LIBRARY_REAL "${SDL2_LIBRARY_REAL}")
        ENDIF(MINGW)

        message("SDL2 LIB: ${SDL2_LIBRARY}")
        message("SDL2 LIB REAL: ${SDL2_LIBRARY_REAL}")

        IF(MINGW)
                FILE(GLOB LIBSDL2 "${SDL2_LIBRARY_REAL}.${SHARED_LIBRARY_SUFFIX}")
                INSTALL(FILES "${LIBSDL2}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ELSE(MINGW)
                FILE(GLOB LIBSDL2 "${SDL2_LIBRARY}-2.0.${SHARED_LIBRARY_SUFFIX}.*.*.*")
                INSTALL(FILES "${LIBSDL2}" DESTINATION "${INSTALL_PATH}" RENAME libSDL2-2.0.${SHARED_LIBRARY_SUFFIX}.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ENDIF(MINGW)

        #INSTALL(FILES "/usr/lib/${MULTIARCH_PATH}/liblcms.so.1.0.19" DESTINATION "./lib" RENAME "liblcms.so.1" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")

        # old unused
        #exec_program("dirname" ARGS ${Boost_FILESYSTEM_LIBRARY} OUTPUT_VARIABLE BOOSTDIR)

        ##dirty hack to keep the right boost libs for linking
        #set(BOOST_TMP_LIBS ${Boost_LIBRARIES})

        #if(Boost_VERSION GREATER 104900)
        #        SET(BOOST_PACKAGE_COMPONENTS ${BOOST_PACKAGE_COMPONENTS} chrono)
        #endif()

        ##SET(BOOST_PACKAGE_COMPONENTS ${BOOST_PACKAGE_COMPONENTS} thread date_time wave)
        #SET(BOOST_PACKAGE_COMPONENTS ${BOOST_PACKAGE_COMPONENTS} thread iostreams)

        #IF(MINGW)
        #  SET(BOOST_PACKAGE_COMPONENTS ${BOOST_PACKAGE_COMPONENTS} thread iostreams locale)
        #ENDIF(MINGW)

        #find_package(Boost REQUIRED COMPONENTS ${BOOST_PACKAGE_COMPONENTS})

        #set(Boost_LIBRARIES ${BOOST_TMP_LIBS})

        #FIXME: Item names do not correspond linked names. How can we find those?

        #Reading symbolic links and copying the libs into ${INSTALL_PATH}
        INSTALL(DIRECTORY DESTINATION "${INSTALL_PATH}" COMPONENT "openmw")

        #TODO: Remove unnecessary commands and messages
        #TODO: Need better readlink algorithm for stuff like openal
        exec_program("dirname" ARGS ${OPENAL_LIBRARY} OUTPUT_VARIABLE OPENAL_DIRNAME)
        exec_program("readlink" ARGS ${OPENAL_LIBRARY} OUTPUT_VARIABLE NEXT_OPENAL_LINK)
        exec_program("readlink" ARGS "${OPENAL_DIRNAME}/${NEXT_OPENAL_LINK}" OUTPUT_VARIABLE REAL_OPENAL_LIBRARY)
#        message("${NEXT_OPENAL_LINK}")
#        message("${REAL_OPENAL_LIBRARY}")
        #TODO: We need to get rid of things like this extra stuff for pthread and freeimage ...
        #exec_program("readlink" ARGS ${PTHREAD_LIBRARY} OUTPUT_VARIABLE PTHREAD_READLINK)
        #INSTALL(FILES "/lib/${PTHREAD_READLINK}" DESTINATION "./lib" RENAME "libpthread.so.0" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #exec_program("readlink" ARGS ${FREEIMAGE_LIBRARY} OUTPUT_VARIABLE FREEIMAGE_READLINK)
        #INSTALL(FILES "/usr/lib/${FREEIMAGE_READLINK}" DESTINATION "./lib" RENAME "libfreeimage.so.3" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")

        IF(MINGW)
                SET(REAL_FFMPEG_LIBRARIES "")
                FOREACH(CURRENT_ITEM ${FFmpeg_LIBRARIES})
                        string(REGEX REPLACE "(.*)\/lib\/(.*)" "\\1/bin/\\2" CURRENT_ITEM "${CURRENT_ITEM}")
                        string(REGEX REPLACE "(.*\/)lib(.*).dll.a" "\\1\\2" CURRENT_ITEM "${CURRENT_ITEM}")
                        #message("${CURRENT_ITEM}")
                        FILE(GLOB CURRENT_ITEM "${CURRENT_ITEM}*.dll")
                        #message("${CURRENT_ITEM}")
                        INSTALL(FILES "${CURRENT_ITEM}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
                ENDFOREACH(CURRENT_ITEM ${FFmpeg_LIBRARIES})
        ENDIF(MINGW)

        # bullet debian package version
        #set(BULLET3_COMMON_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libBullet3Common-float64.${SHARED_LIBRARY_SUFFIX}")
        #set(BULLET3_GEOMETRY_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libBullet3Geometry-float64.${SHARED_LIBRARY_SUFFIX}")
        #set(BULLET3_COLLISION_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libBullet3Collision-float64.${SHARED_LIBRARY_SUFFIX}")
        #set(BULLET_COLLISION_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libBulletCollision-float64.${SHARED_LIBRARY_SUFFIX}")
        #set(BULLET3_DYNAMICS_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libBullet3Dynamics-float64.${SHARED_LIBRARY_SUFFIX}")
        #set(BULLET_DYNAMICS_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libBulletDynamics-float64.${SHARED_LIBRARY_SUFFIX}")
        #set(BULLET_MATH_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libLinearMath-float64.${SHARED_LIBRARY_SUFFIX}")
        #set(BULLET_SOFTBODY_LIBRARY "${SYSTEM_SHARED_LIB_PATH}/libBulletSoftBody-float64.${SHARED_LIBRARY_SUFFIX}")
        # bullet local build
        set(BULLET3_COMMON_LIBRARY "${LOCAL_SHARED_LIB_PATH}/libBullet3Common.${SHARED_LIBRARY_SUFFIX}")
        set(BULLET3_GEOMETRY_LIBRARY "${LOCAL_SHARED_LIB_PATH}/libBullet3Geometry.${SHARED_LIBRARY_SUFFIX}")
        set(BULLET3_COLLISION_LIBRARY "${LOCAL_SHARED_LIB_PATH}/libBullet3Collision.${SHARED_LIBRARY_SUFFIX}")
        set(BULLET_COLLISION_LIBRARY "${LOCAL_SHARED_LIB_PATH}/libBulletCollision.${SHARED_LIBRARY_SUFFIX}")
        set(BULLET3_DYNAMICS_LIBRARY "${LOCAL_SHARED_LIB_PATH}/libBullet3Dynamics.${SHARED_LIBRARY_SUFFIX}")
        set(BULLET_DYNAMICS_LIBRARY "${LOCAL_SHARED_LIB_PATH}/libBulletDynamics.${SHARED_LIBRARY_SUFFIX}")
        set(BULLET_MATH_LIBRARY "${LOCAL_SHARED_LIB_PATH}/libLinearMath.${SHARED_LIBRARY_SUFFIX}")
        set(BULLET_SOFTBODY_LIBRARY "${LOCAL_SHARED_LIB_PATH}/libBulletSoftBody.${SHARED_LIBRARY_SUFFIX}")
        set(Bullet_LIBRARIES ${BULLET3_COMMON_LIBRARY} ${BULLET3_GEOMETRY_LIBRARY} ${BULLET3_COLLISION_LIBRARY} ${BULLET_COLLISION_LIBRARY} ${BULLET3_DYNAMICS_LIBRARY} ${BULLET_DYNAMICS_LIBRARY} ${BULLET_MATH_LIBRARY} ${BULLET_SOFTBODY_LIBRARY})

        #Libs that are linked with major version numbers
        IF(MINGW)
          set(LIBITEMS ${UUID_LIBRARY})
        ELSE(MINGW)
          set(LIBITEMS ${MPG123_LIBRARY} ${Freetype_LIBRARY} ${SNDFILE_LIBRARY} ${PNG_LIBRARY} ${JPEG_LIBRARY} ${GOMP_LIBRARY} ${COLLADA_LIBRARY} ${UUID_LIBRARY}
          ${FLAC_LIBRARY} ${VORBISENC_LIBRARY} ${VORBIS_LIBRARY} ${OGG_LIBRARY} ${ZZIP_LIBRARY} ${SOUND_INPUT_LIBRARY} ${EXPAT_LIBRARY} ${GRAPHITE_LIBRARY} ${HARFBUZZ_LIBRARY} ${GLIB_LIBRARY} ${GTHREAD_LIBRARY} ${PCRE2_8_LIBRARY} ${PCRE2_16_LIBRARY} ${PCRECPP_LIBRARY} ${XML2_LIBRARY} ${LZMA_LIBRARY} ${LUAJIT_LIBRARY} ${SQLITE_LIBRARY}
	  "${OPENAL_DIRNAME}/${REAL_OPENAL_LIBRARY}" ${FFmpeg_LIBRARIES} ${LZ4_LIBRARY} ${LIBDEBUGUTILS_LIBRARY} ${LIBDETOUR_LIBRARY} ${LIBRECAST_LIBRARY} ${BROTLIDEC_LIBRARY} ${BROTLICOMMON_LIBRARY} ${DOUBLECONVERSION_LIBRARY} ${MD4C_LIBRARY} ${B2_LIBRARY} ${MD_LIBRARY} ${CAP_LIBRARY} ${BSD_LIBRARY} ${ZSTD_LIBRARY} ${XXHASH_LIBRARY} ${PROXY_BACKEND_LIBRARY} ${DUKTAPE_LIBRARY} ${GOBJECT_LIBRARY} ${GMODULE_LIBRARY} ${GIO_LIBRARY} ${FFI_LIBRARY} ${SELINUX_LIBRARY})
        ENDIF(MINGW)

    if(BUILD_LAUNCHER)
        #This is also done in the Main CMakeLists.txt
        #but after the call to find_tgz_deps
        #find_package(LIBUNSHIELD REQUIRED)
        #if(NOT LIBUNSHIELD_FOUND)
        #       message(SEND_ERROR "Failed to find libunshield")
        #endif(NOT LIBUNSHIELD_FOUND)
        IF(MINGW)
                FILE(GLOB LIBUNSHIELD "${LOCAL_SHARED_LIB_PATH}${MULTIARCH_PATH}/libunshield*.${SHARED_LIBRARY_SUFFIX}")
                #TODO: Build unshield
        ELSE(MINGW)
                #FILE(GLOB LIBUNSHIELD "${LOCAL_SHARED_LIB_PATH}${MULTIARCH_PATH}/libunshield.${SHARED_LIBRARY_SUFFIX}.*.*.*")
                FILE(GLOB LIBUNSHIELD "${SYSTEM_SHARED_LIB_PATH}/libunshield.${SHARED_LIBRARY_SUFFIX}.*.*.*")
                INSTALL(FILES "${LIBUNSHIELD}" DESTINATION "${INSTALL_PATH}" RENAME libunshield.${SHARED_LIBRARY_SUFFIX}.0 PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        ENDIF(MINGW)

        #set(LIBITEMS ${LIBITEMS} ${LIBUNSHIELD_LIBRARY})
    endif()

        message("Libraries linked with major version:")
foreach(CURRENT_ITEM ${LIBITEMS})
        message("${CURRENT_ITEM}")
endforeach(CURRENT_ITEM)
foreach(CURRENT_ITEM ${LIBITEMS})
        IF(MINGW)
            string(REGEX REPLACE "(.*)\/lib\/(.*)" "\\1/bin/\\2" CURRENT_ITEM "${CURRENT_ITEM}")
            string(REGEX REPLACE "(.*).dll.a" "\\1.dll" CURRENT_ITEM "${CURRENT_ITEM}")
        ENDIF(MINGW)

        exec_program("readlink" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_READLINK)
        #message("${ITEM_READLINK}")
        if("${ITEM_READLINK}" STREQUAL "")
                exec_program("basename" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_NAME)
                if(${ITEM_READLINK_NAME} MATCHES ".+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+\\.[0-9]+\\.[0-9]+")
                  string(REGEX REPLACE "(.+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+)\\.[0-9]+\\.[0-9]+" "\\1" ITEM_MAJOR_VERSION_NAME ${ITEM_NAME})
                else()
                  string(REGEX REPLACE "(.+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+)\\.[0-9]+" "\\1" ITEM_MAJOR_VERSION_NAME ${ITEM_READLINK_NAME})
                endif()
                INSTALL(FILES "${CURRENT_ITEM}" DESTINATION "${INSTALL_PATH}" RENAME ${ITEM_MAJOR_VERSION_NAME} PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
#                message("${CURRENT_ITEM}")
#                message("${ITEM_NAME}")
        else()
                exec_program("dirname" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_DIRNAME)
                exec_program("basename" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_NAME)
                exec_program("basename" ARGS ${ITEM_READLINK} OUTPUT_VARIABLE ITEM_READLINK_NAME)
#                message("BASENAME: ${ITEM_NAME}")
                if(${ITEM_READLINK_NAME} MATCHES ".+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+\\.[0-9]+\\.[0-9]+")
                  string(REGEX REPLACE "(.+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+)\\.[0-9]+\\.[0-9]+" "\\1" ITEM_MAJOR_VERSION_NAME ${ITEM_READLINK_NAME})
                else()
                  string(REGEX REPLACE "(.+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+)\\.[0-9]+" "\\1" ITEM_MAJOR_VERSION_NAME ${ITEM_READLINK_NAME})
                endif()
                INSTALL(FILES "${ITEM_DIRNAME}/${ITEM_READLINK}" DESTINATION "${INSTALL_PATH}" RENAME ${ITEM_MAJOR_VERSION_NAME} PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
#                message("${ITEM_DIRNAME}/${ITEM_READLINK}")
#                message("Major Version Name: ${ITEM_MAJOR_VERSION_NAME}")
        endif("${ITEM_READLINK}" STREQUAL "")
endforeach(CURRENT_ITEM)

        message("Libraries linked with major and minor version:")
        IF(MINGW)
          set(LIBITEMS ${Bullet_LIBRARIES})
        ELSE(MINGW)
          set(LIBITEMS ${Bullet_LIBRARIES})
        ENDIF(MINGW)

foreach(CURRENT_ITEM ${LIBITEMS})
        message("${CURRENT_ITEM}")
endforeach(CURRENT_ITEM)
foreach(CURRENT_ITEM ${LIBITEMS})
        IF(MINGW)
            string(REGEX REPLACE "(.*)\/lib\/(.*)" "\\1/bin/\\2" CURRENT_ITEM "${CURRENT_ITEM}")
            string(REGEX REPLACE "(.*).dll.a" "\\1.dll" CURRENT_ITEM "${CURRENT_ITEM}")
        ENDIF(MINGW)

        exec_program("readlink" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_READLINK)
        #message("${ITEM_READLINK}")
        if("${ITEM_READLINK}" STREQUAL "")
                exec_program("basename" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_NAME)
                if(${ITEM_READLINK_NAME} MATCHES ".+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+\\.[0-9]+\\.[0-9]+")
                  string(REGEX REPLACE "(.+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+\\.[0-9]+)\\.[0-9]+" "\\1" ITEM_MAJOR_VERSION_NAME ${ITEM_NAME})
                else()
                  string(REGEX REPLACE "(.+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+\\.[0-9]+)" "\\1" ITEM_MAJOR_VERSION_NAME ${ITEM_READLINK_NAME})
                endif()
                INSTALL(FILES "${CURRENT_ITEM}" DESTINATION "${INSTALL_PATH}" RENAME ${ITEM_MAJOR_VERSION_NAME} PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
#                message("${CURRENT_ITEM}")
#                message("${ITEM_NAME}")
        else()
                exec_program("dirname" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_DIRNAME)
                exec_program("basename" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_NAME)
                exec_program("basename" ARGS ${ITEM_READLINK} OUTPUT_VARIABLE ITEM_READLINK_NAME)
#                message("BASENAME: ${ITEM_NAME}")
                if(${ITEM_READLINK_NAME} MATCHES ".+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+\\.[0-9]+\\.[0-9]+")
                  string(REGEX REPLACE "(.+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+\\.[0-9]+)\\.[0-9]+" "\\1" ITEM_MAJOR_VERSION_NAME ${ITEM_READLINK_NAME})
                else()
                  string(REGEX REPLACE "(.+\\.${SHARED_LIBRARY_SUFFIX}\\.[0-9]+\\.[0-9]+)" "\\1" ITEM_MAJOR_VERSION_NAME ${ITEM_READLINK_NAME})
                endif()
                INSTALL(FILES "${ITEM_DIRNAME}/${ITEM_READLINK}" DESTINATION "${INSTALL_PATH}" RENAME ${ITEM_MAJOR_VERSION_NAME} PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
#                message("${ITEM_DIRNAME}/${ITEM_READLINK}")
#                message("Major Version Name: ${ITEM_MAJOR_VERSION_NAME}")
        endif("${ITEM_READLINK}" STREQUAL "")
endforeach(CURRENT_ITEM)

        # Boost defines (not provided by cmake anymore)
        # (commented libraries not required by openmw)
        #set(_Boost_DATE_TIME_LIBRARY ${SYSTEM_SHARED_LIB_PATH}/libboost_date_time.${SHARED_LIBRARY_SUFFIX})
        #set(_Boost_FILESYSTEM_LIBRARY ${SYSTEM_SHARED_LIB_PATH}/libboost_filesystem.${SHARED_LIBRARY_SUFFIX})
        set(_Boost_PROGRAM_OPTIONS_LIBRARY ${SYSTEM_SHARED_LIB_PATH}/libboost_program_options.${SHARED_LIBRARY_SUFFIX})
        set(_Boost_SYSTEM_LIBRARY ${SYSTEM_SHARED_LIB_PATH}/libboost_system.${SHARED_LIBRARY_SUFFIX})
        #set(_Boost_THREAD_LIBRARY ${SYSTEM_SHARED_LIB_PATH}/libboost_thread.${SHARED_LIBRARY_SUFFIX})
        #set(_Boost_WAVE_LIBRARY ${SYSTEM_SHARED_LIB_PATH}/libboost_wave.${SHARED_LIBRARY_SUFFIX})
        #set(_Boost_CRHONO_LIBRARY ${SYSTEM_SHARED_LIB_PATH}/libboost_chrono.${SHARED_LIBRARY_SUFFIX})
        set(_Boost_IOSTREAMS_LIBRARY ${SYSTEM_SHARED_LIB_PATH}/libboost_iostreams.${SHARED_LIBRARY_SUFFIX})
        IF(MINGW)
            set(_Boost_LOCALE_LIBRARY ${SYSTEM_SHARED_LIB_PATH}/libboost_locale.${SHARED_LIBRARY_SUFFIX})
        ENDIF(MINGW)

        #set(_Boost_DATE_TIME_LIBRARY_DBG ${SYSTEM_SHARED_LIB_PATH}/libboost_date_time-d.${SHARED_LIBRARY_SUFFIX})
        #set(_Boost_FILESYSTEM_LIBRARY_DBG ${SYSTEM_SHARED_LIB_PATH}/libboost_filesystem-d.${SHARED_LIBRARY_SUFFIX})
        set(_Boost_PROGRAM_OPTIONS_LIBRARY_DBG ${SYSTEM_SHARED_LIB_PATH}/libboost_program_options-d.${SHARED_LIBRARY_SUFFIX})
        set(_Boost_SYSTEM_LIBRARY_DBG ${SYSTEM_SHARED_LIB_PATH}/libboost_system-d.${SHARED_LIBRARY_SUFFIX})
        #set(_Boost_THREAD_LIBRARY_DBG ${SYSTEM_SHARED_LIB_PATH}/libboost_thread-d.${SHARED_LIBRARY_SUFFIX})
        #set(_Boost_WAVE_LIBRARY_DBG ${SYSTEM_SHARED_LIB_PATH}/libboost_wave-d.${SHARED_LIBRARY_SUFFIX})
        #set(_Boost_CRHONO_LIBRARY_DBG ${SYSTEM_SHARED_LIB_PATH}/libboost_chrono-d.${SHARED_LIBRARY_SUFFIX})
        set(_Boost_IOSTREAMS_LIBRARY_DBG ${SYSTEM_SHARED_LIB_PATH}/libboost_iostreams-d.${SHARED_LIBRARY_SUFFIX})
        IF(MINGW)
            set(_Boost_LOCALE_LIBRARY_DBG ${SYSTEM_SHARED_LIB_PATH}/libboost_locale-d.${SHARED_LIBRARY_SUFFIX})
        ENDIF(MINGW)

        #Libs that are linked with the full version number
        if(${CMAKE_BUILD_TYPE} MATCHES "Debug")
                IF(MINGW)
                  set(LIBITEMS ${_Boost_DATE_TIME_LIBRARY_DBG} ${_Boost_FILESYSTEM_LIBRARY_DBG} ${_Boost_PROGRAM_OPTIONS_LIBRARY_DBG} ${_Boost_SYSTEM_LIBRARY_DBG} ${_Boost_THREAD_LIBRARY_DBG} ${_Boost_WAVE_LIBRARY_DBG}
                  ${_Boost_CHRONO_LIBRARY_DBG} ${_Boost_IOSTREAMS_LIBRARY_DBG} ${_Boost_LOCALE_LIBRARY_DBG} ${OIS_LIBRARY_REL})
                ELSE(MINGW)
                  set(LIBITEMS ${_Boost_DATE_TIME_LIBRARY_DBG} ${_Boost_FILESYSTEM_LIBRARY_DBG} ${_Boost_PROGRAM_OPTIONS_LIBRARY_DBG} ${_Boost_SYSTEM_LIBRARY_DBG} ${_Boost_THREAD_LIBRARY_DBG} ${_Boost_WAVE_LIBRARY_DBG}
                  ${_Boost_CHRONO_LIBRARY_DBG} ${_Boost_IOSTREAMS_LIBRARY_DBG} ${OIS_LIBRARY_REL})
                ENDIF(MINGW)
        else()
                IF(MINGW)
                  set(LIBITEMS ${_Boost_DATE_TIME_LIBRARY} ${_Boost_FILESYSTEM_LIBRARY} ${_Boost_PROGRAM_OPTIONS_LIBRARY} ${_Boost_SYSTEM_LIBRARY} ${_Boost_THREAD_LIBRARY} ${_Boost_WAVE_LIBRARY}
                        ${_Boost_CHRONO_LIBRARY} ${_Boost_IOSTREAMS_LIBRARY} ${_Boost_LOCALE_LIBRARY} ${OIS_LIBRARY_REL})
                ELSE(MINGW)
                  set(LIBITEMS ${_Boost_DATE_TIME_LIBRARY} ${_Boost_FILESYSTEM_LIBRARY} ${_Boost_PROGRAM_OPTIONS_LIBRARY} ${_Boost_SYSTEM_LIBRARY} ${_Boost_THREAD_LIBRARY} ${_Boost_WAVE_LIBRARY}
                  ${_Boost_CHRONO_LIBRARY} ${_Boost_IOSTREAMS_LIBRARY} ${OIS_LIBRARY_REL})
                ENDIF(MINGW)
        endif()

        message("Libraries linked with full version:")
foreach(CURRENT_ITEM ${LIBITEMS})
        message("${CURRENT_ITEM}")
endforeach(CURRENT_ITEM)
foreach(CURRENT_ITEM ${LIBITEMS})
        IF(MINGW)
            string(REGEX REPLACE "(.*)\/lib\/(.*)" "\\1/bin/\\2" CURRENT_ITEM "${CURRENT_ITEM}")
            string(REGEX REPLACE "(.*).dll.a" "\\1.dll" CURRENT_ITEM "${CURRENT_ITEM}")
        ENDIF(MINGW)
        exec_program("readlink" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_READLINK)
        #message("${ITEM_READLINK}")
        if("${ITEM_READLINK}" STREQUAL "")
                INSTALL(FILES "${CURRENT_ITEM}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
                #message("${CURRENT_ITEM}")
        else()
                exec_program("dirname" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_DIRNAME)
                exec_program("basename" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_NAME)
                #message("BASENAME: ${ITEM_NAME}")
                INSTALL(FILES "${ITEM_DIRNAME}/${ITEM_READLINK}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
                #message("${ITEM_DIRNAME}/${ITEM_READLINK}")
        endif("${ITEM_READLINK}" STREQUAL "")
endforeach(CURRENT_ITEM)

#message("OSG LIBS: ${OPENSCENEGRAPH_LIBRARIES}")
#Copy libraries and symlinks for osg
foreach(CURRENT_ITEM ${OPENSCENEGRAPH_LIBRARIES})
      IF(MINGW)
            string(REGEX REPLACE "(.*)\/lib\/(.*)" "\\1/bin/\\2" CURRENT_ITEM "${CURRENT_ITEM}")
      ENDIF(MINGW)
      string(REGEX REPLACE "(.+\\.${SHARED_LIBRARY_SUFFIX})\\.[0-9]+\\.[0-9]+\\.[0-9]+" "\\1" ITEM_SO_NAME ${CURRENT_ITEM})
      file(GLOB SO_LIST "${ITEM_SO_NAME}*")
      foreach(CURRENT_ITEM_2 ${SO_LIST})
        exec_program("basename" ARGS ${CURRENT_ITEM_2} OUTPUT_VARIABLE ITEM_NAME)
        INSTALL(FILES "${CURRENT_ITEM_2}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
      endforeach(CURRENT_ITEM_2 ${SO_LIST})
endforeach(CURRENT_ITEM)

file(GLOB OSGTEXT_LIBS "${LOCAL_SHARED_LIB_PATH}/libosgText.${SHARED_LIBRARY_SUFFIX}*")
file(GLOB OSGWIDGET_LIBS "${LOCAL_SHARED_LIB_PATH}/libosgWidget.${SHARED_LIBRARY_SUFFIX}*")
file(GLOB OSGSIM_LIBS "${LOCAL_SHARED_LIB_PATH}/libosgSim.${SHARED_LIBRARY_SUFFIX}*")

IF(MINGW)
  file(GLOB OSGOPENTHREADS_LIBS "${LOCAL_SHARED_LIB_MULTILIB_PATH}/libOpenThreads.${SHARED_LIBRARY_SUFFIX}*")
  file(GLOB OSG_LIBS "${LOCAL_SHARED_LIB_MULTILIB_PATH}/libosg.${SHARED_LIBRARY_SUFFIX}")
  file(GLOB OSGDB_LIBS "${LOCAL_SHARED_LIB_MULTILIB_PATH}/libosgDB.${SHARED_LIBRARY_SUFFIX}")
  file(GLOB OSGGA_LIBS "${LOCAL_SHARED_LIB_MULTILIB_PATH}/libosgGA.${SHARED_LIBRARY_SUFFIX}")
  file(GLOB OSGPARTICLE_LIBS "${LOCAL_SHARED_LIB_MULTILIB_PATH}/libosgParticle.${SHARED_LIBRARY_SUFFIX}")
  file(GLOB OSGSHADOW_LIBS "${LOCAL_SHARED_LIB_MULTILIB_PATH}/libosgShadow.${SHARED_LIBRARY_SUFFIX}")
  file(GLOB OSGUTIL_LIBS "${LOCAL_SHARED_LIB_MULTILIB_PATH}/libosgUtil.${SHARED_LIBRARY_SUFFIX}")
  file(GLOB OSGVIEWER_LIBS "${LOCAL_SHARED_LIB_MULTILIB_PATH}/libosgViewer.${SHARED_LIBRARY_SUFFIX}")
  set(OPENSCENEGRAPH_LIBRARIES_TGZ "${OSG_LIBS}" "${OSGDB_LIBS}" "${OSGGA_LIBS}" "${OSGPARTICLE_LIBS}" "${OSGSHADOW_LIBS}" "${OSGUTIL_LIBS}" "${OSGVIEWER_LIBS}" "${OSGTEXT_LIBS}" "${OSGWIDGET_LIBS}" "${OSGSIM_LIBS}" "${OSGOPENTHREADS_LIBS}")
ELSE(MINGW)
  set(OPENSCENEGRAPH_LIBRARIES_TGZ ${OSGTEXT_LIBS} ${OSGWIDGET_LIBS} ${OSGSIM_LIBS})
ENDIF(MINGW)

#Also need OsgText and OsgWidget
foreach(CURRENT_ITEM ${OPENSCENEGRAPH_LIBRARIES_TGZ})
        #IF(MINGW)
        #       string(REGEX REPLACE "(.*)\/lib\/(.*)" "\\1/bin/\\2" CURRENT_ITEM "${CURRENT_ITEM}")
        #       string(REGEX REPLACE "(.*).dll.a" "\\1.dll" CURRENT_ITEM "${CURRENT_ITEM}")
        #ENDIF(MINGW)
        INSTALL(FILES "${CURRENT_ITEM}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        #exec_program("basename" ARGS ${CURRENT_ITEM} OUTPUT_VARIABLE ITEM_NAME)
endforeach(CURRENT_ITEM ${OPENSCENEGRAPH_LIBRARIES_TGZ})

#And OSG Plugins
# todo officially add dae?
foreach (PLUGIN_NAME ${USED_OSG_PLUGINS} osgdb_dae osgdb_glsl)
  IF(MINGW)
          set(PLUGIN_ABS "${OSGPlugins_LIB_DIR}/mingw_${PLUGIN_NAME}.${SHARED_LIBRARY_SUFFIX}")
          string(REGEX REPLACE "(.*)\/lib\/(.*)" "\\1/bin/\\2" PLUGIN_ABS "${PLUGIN_ABS}")
  ELSE(MINGW)
          set(PLUGIN_ABS "${OSGPlugins_LIB_DIR}/${PLUGIN_NAME}.${SHARED_LIBRARY_SUFFIX}")
  ENDIF(MINGW)
  INSTALL(FILES "${PLUGIN_ABS}" DESTINATION "${INSTALL_PATH}/osgPlugins-${OPENSCENEGRAPH_VERSION}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
endforeach ()

# Qt and dependencies

IF(MINGW)
        FILE(GLOB LIBSSP "${USER_SHARED_LIB_PATH}/libssp*.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBSSP}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")

        FILE(GLOB LIBICONV "${USER_SHARED_LIB_PATH}/libiconv*.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBICONV}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        FILE(GLOB LIBINTL "${USER_SHARED_LIB_PATH}/libintl*.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBINTL}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        FILE(GLOB LIBPCRE "${USER_SHARED_LIB_PATH}/libpcre-1*.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBPCRE}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        FILE(GLOB LIBPCRE2 "${USER_SHARED_LIB_PATH}/libpcre2-16*.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBPCRE2}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        FILE(GLOB LIBZLIB "${USER_SHARED_LIB_PATH}/zlib*.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBZLIB}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        FILE(GLOB LIBPNG "${USER_SHARED_LIB_PATH}/libpng*.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBPNG}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        FILE(GLOB LIBZSTD "${USER_SHARED_LIB_PATH}/libzstd*.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBZSTD}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        FILE(GLOB LIBLZMA "${USER_SHARED_LIB_PATH}/liblzma*.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBLZMA}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        FILE(GLOB LIBGLIB2 "${USER_SHARED_LIB_PATH}/libglib-2*.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBGLIB2}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        FILE(GLOB LIBHARFBUZZ "${USER_SHARED_LIB_PATH}/libharfbuzz-0.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBHARFBUZZ}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        FILE(GLOB LIBGRAPHITE "${USER_SHARED_LIB_PATH}/libgraphite2.${SHARED_LIBRARY_SUFFIX}")
        INSTALL(FILES "${LIBGRAPHITE}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
        set(QT_LIBRARIES ${SYSTEM_SHARED_LIB_PATH}/Qt6Core.${SHARED_LIBRARY_SUFFIX}
                         ${SYSTEM_SHARED_LIB_PATH}/Qt6Gui.${SHARED_LIBRARY_SUFFIX}
                         ${SYSTEM_SHARED_LIB_PATH}/Qt6Network.${SHARED_LIBRARY_SUFFIX}
                         ${SYSTEM_SHARED_LIB_PATH}/Qt6Widgets.${SHARED_LIBRARY_SUFFIX})
  foreach(QT_LIB ${QT_LIBRARIES})
          #string(REGEX REPLACE "(.*)\/lib\/(.*)" "\\1/bin/\\2" CURRENT_ITEM "${CURRENT_ITEM}")
          #string(REGEX REPLACE "(.*).dll.a" "\\1.dll" CURRENT_ITEM "${CURRENT_ITEM}")
      INSTALL(FILES "${QT_LIB}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
  endforeach(QT_LIB ${QT_LIBRARIES})
# qpa plugins
INSTALL(DIRECTORY "${QPA_PLUGINS_PATH}" DESTINATION "." DIRECTORY_PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
ELSE(MINGW)
  set(ICU_LIBRARIES ${USER_SHARED_LIB_PATH}/libicuuc.${SHARED_LIBRARY_SUFFIX}.76
                    ${USER_SHARED_LIB_PATH}/libicuuc.${SHARED_LIBRARY_SUFFIX}.76.1
                    ${USER_SHARED_LIB_PATH}/libicui18n.${SHARED_LIBRARY_SUFFIX}.76
                    ${USER_SHARED_LIB_PATH}/libicui18n.${SHARED_LIBRARY_SUFFIX}.76.1
                    ${USER_SHARED_LIB_PATH}/libicudata.${SHARED_LIBRARY_SUFFIX}.76
                    ${USER_SHARED_LIB_PATH}/libicudata.${SHARED_LIBRARY_SUFFIX}.76.1)

  foreach(ICU_LIB ${ICU_LIBRARIES})
      INSTALL(FILES "${ICU_LIB}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
  endforeach(ICU_LIB ${ICU_LIBRARIES})

  set(QT_LIBRARIES ${SYSTEM_SHARED_LIB_PATH}/libQt6Concurrent.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Concurrent.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Core.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Core.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6DBus.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6DBus.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6EglFSDeviceIntegration.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6EglFSDeviceIntegration.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6EglFsKmsSupport.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6EglFsKmsSupport.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6EglFsKmsGbmSupport.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6EglFsKmsGbmSupport.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Gui.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Gui.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Network.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Network.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6OpenGL.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6OpenGL.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6OpenGLWidgets.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6OpenGLWidgets.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Svg.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Svg.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Widgets.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Widgets.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6WaylandClient.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6WaylandClient.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6XcbQpa.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6XcbQpa.${SHARED_LIBRARY_SUFFIX}.6.8.2
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Xml.${SHARED_LIBRARY_SUFFIX}.6
                   ${SYSTEM_SHARED_LIB_PATH}/libQt6Xml.${SHARED_LIBRARY_SUFFIX}.6.8.2)

  foreach(QT_LIB ${QT_LIBRARIES})
      INSTALL(FILES "${QT_LIB}" DESTINATION "${INSTALL_PATH}" PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
  endforeach(QT_LIB ${QT_LIBRARIES})

  # qpa plugins
  INSTALL(DIRECTORY "${QPA_PLUGINS_PATH}" DESTINATION "." DIRECTORY_PERMISSIONS OWNER_READ OWNER_WRITE OWNER_EXECUTE GROUP_READ GROUP_EXECUTE WORLD_READ WORLD_EXECUTE COMPONENT "openmw")
ENDIF(MINGW)

endmacro (find_tgz_deps)
